//"Nuclear Flux", Maarten Dinger, 2005

global_settings { 
  ambient_light 0
  assumed_gamma 1.9
  max_trace_level 64 }

//Light

light_source { 0,color rgb <1.02,1,1>*150000 fade_distance 1 fade_power 2 area_light <4, 0, 0>, <0, 0, 4>, 3, 3 circular orient adaptive 1 jitter 
   looks_like { box { -0.5,0.5 hollow scale <50,1,100> 
   pigment { rgbt 1 } finish { diffuse 0 ambient 0 } interior { media { emission 1000} } } }
   translate <-180,200,150> }

//Camera

camera { direction z location <2,6,11> look_at <0,0,0> up <0,1,0> right <-1.33, 0, 0> }

//Sky and Ground

sky_sphere { pigment { color rgb <1.05,1,1> } }

plane { <0, 1, 0>, -1 pigment { color rgb <1 1 1> } translate <0,-3.5,0> }
   
//Skeleton

#include "SkeletonModel.inc"

#declare BonesTex = texture { pigment { bozo turbulence 1 scale 0.5 frequency 1
   color_map { [0.0 color <0.226 0.227 0.204>*4 ]
               [0.5 color <0.190 0.168 0.160>*4] 
               [1.0 color <0.226 0.227 0.204>*4 ] } }
   normal { granite 0.2 scale 0.2 } } 

#declare TeethTex = texture { pigment { bozo turbulence 1 scale 0.1
   color_map {[0.1 color <0.190 0.168 0.140>*5]
              [0.6 color <0.226 0.227 0.204>*5 ] } }          
   normal { granite 0.3 scale 0.7} } 

union {
   object { Bones texture { BonesTex } rotate <0,85,0> }
   object { Teeth texture { TeethTex } rotate <0,85,0> }
   translate <0,-3.5,1.5> scale 1.35 }       


//Vapourising effect 

#include "SkeletonSmoke.inc"
#declare n=0.025;
#declare sign=1;   
#while (n<0.9)
   object { Smoke pigment { color rgbt <0.50,0.42,0.35,0.95+(n/20)> } 
      rotate <0,85+(n*15),0> 
      translate <(n/10)*sign, -3.5+n, 1.5-(n/1.9)> 
      scale 1.35+(n/10) }
   #declare n=n+0.025;
   #declare sign=sign*(1+(n/4))*-1;
#end
